// brain bot for sci-fi work
// m.miller 07.18.2023

//M_blue_glow
//M_red_glow  
//M_glass_red

/*  --- use for quick sudo alpha
#declare _m_glass =      M_gray50_satin;
#declare _m_glass_butt = M_gray50_satin;
#declare _m_metal =      M_gray50_satin;
#declare _m_metal =      M_gray50_satin;
#declare _m_glow =       M_gray50_satin;
#declare _m_eye =        M_gray50_satin;
#declare _m_brain =      M_gray50_satin;
*/

#declare _m_glass =      M_glass2;
#declare _m_glass_butt = M_glass2;
#declare _m_metal =      M_pearl_metal;
#declare _m_glow =       M_blue_glow;
#declare _m_eye =        M_pearl_metal;
#declare _m_brain =      M_red_dull;



// -----------------------------------------------------------------------------------------
//                     B O D Y
//------------------------------------------------------------------------------------------
#declare body_lathe =
lathe{ 
      cubic_spline
      74,
     <-0.000, 28.005>,
     <-0.000, 28.005>,
     <1.959, 27.874>,
     <5.960, 26.976>,
     <9.912, 25.000>,
     <13.355, 21.992>,
     <16.097, 17.979>,
     <17.712, 13.001>,
     <17.590, 6.011>,
     <17.428, 2.557>,
     <17.956, 2.070>,
     <18.646, 0.351>,
     <18.741, -0.043>,
     <18.469, -0.315>,
     <16.795, -1.758>,
     <16.275, -1.763>,
     <16.419, -2.309>,
     <16.691, -3.902>,
     <16.874, -5.330>,
     <16.973, -5.421>,
     <17.332, -5.588>,
     <17.475, -5.938>,
     <17.361, -6.292>,
     <17.121, -6.459>,
     <17.124, -6.516>,
     <17.331, -6.602>,
     <17.534, -7.068>,
     <17.283, -7.456>,
     <17.063, -7.537>,
     <17.066, -7.587>,
     <17.310, -7.687>,
     <17.502, -8.076>,
     <17.309, -8.480>,
     <16.958, -8.613>,
     <16.869, -8.692>,
     <15.833, -13.464>,
     <14.038, -17.053>,
     <11.288, -20.394>,
     <11.223, -20.737>,
     <11.484, -21.259>,
     <10.739, -22.986>,
     <9.385, -23.833>,
     <8.856, -23.852>,
     <8.699, -24.264>,
     <8.464, -28.027>,
     <7.688, -31.483>,
     <6.316, -34.756>,
     <4.180, -37.539>,
     <1.005, -39.264>,
     <-0.000, -39.327>,
     <-0.000, -38.151>,
     <1.012, -38.102>,
     <3.658, -36.991>,
     <5.797, -34.427>,
     <7.131, -31.311>,
     <7.961, -28.031>,
     <8.091, -24.308>,
     <8.028, -23.260>,
     <8.028, -18.059>,
     <14.991, -12.735>,
     <14.991, -1.007>,
     <14.989, 1.250>,
     <14.989, 2.684>,
     <16.001, 3.037>,
     <16.918, 6.000>,
     <17.106, 12.937>,
     <15.507, 17.758>,
     <12.849, 21.638>,
     <9.510, 24.507>,
     <5.728, 26.389>,
     <1.965, 27.271>,
     <0.005, 27.408>,
     <1.965, 27.271>,
     <1.965, 27.271>
      }

#declare _rad = .5;
#declare body =
difference{ 
    object {body_lathe} 
    plane {<0,-1,0>,0 translate <0,3,0,>}
    plane {<0,1,0>,0 translate <0,-24,0,>}   
    material {_m_metal} 
}  

// -----------------------------------------------------------------------------------------
//                     T E N T A C L E   S O C K E T S
//------------------------------------------------------------------------------------------
#declare socket =
lathe{ 
      cubic_spline
      18,
     <-0.000, 7.735>,
     <-0.000, 7.735>,
     <1.841, 7.937>,
     <3.583, 7.735>,
     <4.400, 6.964>,
     <4.683, 5.523>,
     <5.313, 4.060>,
     <5.859, 3.353>,
     <6.776, 3.282>,
     <7.464, 2.234>,
     <7.446, 0.775>,
     <6.684, 0.000>,
     <5.881, 0.000>,
     <0.736, 0.000>,
     <-0.000, 0.000>,
     <-0.000, 0.992>,
     <-0.000, 6.395>,
     <-0.000, 6.395>
     scale <.9,1.1,.9>
      }
      
#declare arm_socket =
union {
    sphere {<0,0,0>,1 scale <3.4,3.4,3.4>}
}


// -----------------------------------------------------------------------------------------
//                     H E L M E T 
//------------------------------------------------------------------------------------------

#declare glass_helmet =
difference{ 
    object {body_lathe  no_shadow }  
    plane {<0,1,0>,0 translate <0,3,0,>} 
    material {_m_glass} 
}



// -----------------------------------------------------------------------------------------
//                     B U T T 
//------------------------------------------------------------------------------------------

#declare p0 = <0, -38.633, 0.000>  ;
#declare p1 = <0, -36.000, 0.000>  ;
#declare p2 = <0, -33.000, 0.000>  ;
#declare p3 = <0, -30.000, 0.000>  ;
#declare p4 = <0, -27.000, 0.000>  ;
#declare p5 = <0, -24.000, 0.000>  ;

#declare r0 = 2.709 ;
#declare r1 = 5.525 ;
#declare r2 = 7.158 ;
#declare r3 = 8.146 ;
#declare r4 = 8.590 ;
#declare r5 = 8.732 ;

#declare butt =
difference{ 
    object {body_lathe}  
    plane {<0,-1,0>,0 translate <0,-24,0,>} 
    torus { r0,_rad translate p0}
    torus { r1,_rad translate p1}
    torus { r2,_rad translate p2}
    torus { r3,_rad translate p3}
    torus { r4,_rad translate p4}
    torus { r5,_rad translate p5}
    material {_m_glass_butt}  
    scale <1,.95,1>
}

#declare butt_bulb = sphere{<0,0,0>,1 material {_m_glow} scale <3,1,3> translate <0,-24,0>}

// light
#declare light_butt =
light_source {
    <0,0,0> 
    #declare light_color = color red 0 green 1 blue 1 ;                      
    light_color * 1000                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 5
    fade_power 2     
    translate <0,-30,0>   
    shadowless
}   

#if (light_butt_on) light_butt #end   



// -----------------------------------------------------------------------------------------
//                     E Y E 
//------------------------------------------------------------------------------------------

#declare void_slot = box {<-.2,20,-20>,<.2,-20,20>}

#declare eye = 
union {
    difference {
        sphere { <0,0,0> 1 scale <10,10,8>  }
        sphere { <0,0,0> 1 scale <9.5,9.5,7.5>    }
        plane {<0,0,1> 0 translate <0,0,-5> }  
        material {_m_eye} 
    }

    difference {
        sphere { <0,0,0> 1 scale <9.5,9.5,7>  material {_m_eye}}
        sphere { <0,0,0> 1 scale <8.2,8.2,6>  material {M_black_gloss}  } 
        sphere { <0,0,0> 4 translate <0,0,-7> material {M_black_gloss} }
        #for (i,0,9)
            object { 
                void_slot
                rotate <0,0,i*36>
            }
        #end
        
    }   

    union {
        difference {
            sphere { <0,0,0> 1 scale <9,9,6.8>    }
            sphere { <0,0,0> 3 translate <0,0,-7> }
            material {M_violet_glow}
        } 
      sphere { <0,0,0> 6.9 translate <0,0,0>  material {_m_eye} }
    }
    
    translate <0,-7,-16>
}



// -----------------------------------------------------------------------------------------
//                     B R A I N S 
//------------------------------------------------------------------------------------------
#declare sf=1.1;
#declare brain_left =
sphere_sweep {
     cubic_spline
     299,
     <-12.890, 25.574, 3.842> , 1*sf
     <-12.890, 25.574, 3.842> , 1*sf
     <-13.668, 25.302, 1.663> , 1*sf
     <-14.051, 24.544, 2.977> , 1*sf
     <-14.067, 24.048, 4.552> , 1*sf
     <-14.783, 22.891, 4.122> , 1*sf
     <-15.019, 23.156, 2.386> , 1*sf
     <-15.691, 22.120, 1.286> , 1*sf
     <-15.850, 21.855, -0.311> , 1*sf
     <-15.492, 22.380, -2.462> , 1*sf
     <-16.107, 21.003, -1.858> , 1*sf
     <-16.608, 19.604, -1.876> , 1*sf
     <-16.546, 20.154, -0.318> , 1*sf
     <-16.592, 19.836, 1.245> , 1*sf
     <-16.938, 18.482, 0.387> , 1*sf
     <-17.029, 17.909, -1.272> , 1*sf
     <-17.087, 16.909, -2.404> , 1*sf
     <-17.265, 15.474, -1.829> , 1*sf
     <-17.280, 16.382, 0.070> , 1*sf
     <-17.411, 14.584, 0.250> , 1*sf
     <-17.307, 13.747, -1.357> , 1*sf
     <-17.092, 12.712, -2.870> , 1*sf
     <-16.673, 12.531, -4.766> , 1*sf
     <-16.776, 11.235, -3.420> , 1*sf
     <-16.665, 9.970, -2.559> , 1*sf
     <-17.016, 11.081, -1.537> , 1*sf
     <-16.983, 10.552, -0.075> , 1*sf
     <-16.569, 8.899, -0.900> , 1*sf
     <-16.089, 7.992, -2.126> , 1*sf
     <-15.674, 7.654, -3.751> , 1*sf
     <-15.202, 6.219, -2.865> , 1*sf
     <-14.594, 4.901, -1.827> , 1*sf
     <-15.418, 6.090, -1.032> , 1*sf
     <-15.578, 6.358, 0.509> , 1*sf
     <-14.644, 4.768, 0.334> , 1*sf
     <-13.748, 3.561, -0.872> , 1*sf
     <-12.736, 2.641, -2.009> , 1*sf
     <-12.864, 2.559, 0.569> , 1*sf
     <-11.899, 1.608, -0.049> , 1*sf
     <-11.489, 1.539, -1.706> , 1*sf
     <-11.272, 1.794, -3.505> , 1*sf
     <-11.077, 2.235, -5.236> , 1*sf
     <-9.647, 0.935, -3.958> , 1*sf
     <-8.012, 0.544, -4.780> , 1*sf
     <-5.531, 1.429, -7.380> , 1*sf
     <-6.459, 0.829, -6.141> , 1*sf
     <-6.401, 0.290, -4.719> , 1*sf
     <-4.861, 0.160, -4.328> , 1*sf
     <-4.720, 0.883, -6.212> , 1*sf
     <-3.507, 1.794, -7.511> , 1*sf
     <-2.169, 1.613, -6.235> , 1*sf
     <-0.555, 2.206, -5.677> , 1*sf
     <-0.117, 3.453, -7.274> , 1*sf
     <-1.665, 2.904, -8.091> , 1*sf
     <-2.736, 3.246, -9.127> , 1*sf
     <-1.504, 4.377, -9.718> , 1*sf
     <-0.039, 4.832, -8.890> , 1*sf
     <-0.030, 6.525, -10.424> , 1*sf
     <-1.638, 6.007, -11.219> , 1*sf
     <-2.557, 4.858, -10.759> , 1*sf
     <-4.271, 3.826, -10.341> , 1*sf
     <-6.246, 3.419, -10.012> , 1*sf
     <-4.664, 2.698, -9.099> , 1*sf
     <-6.344, 2.193, -8.560> , 1*sf
     <-7.773, 3.143, -9.395> , 1*sf
     <-8.450, 4.347, -10.466> , 1*sf
     <-10.040, 4.462, -9.657> , 1*sf
     <-11.175, 4.400, -8.447> , 1*sf
     <-9.941, 3.223, -8.268> , 1*sf
     <-8.535, 2.071, -7.661> , 1*sf
     <-9.092, 1.700, -6.397> , 1*sf
     <-10.519, 2.690, -6.808> , 1*sf
     <-12.183, 3.946, -6.729> , 1*sf
     <-13.783, 5.394, -5.900> , 1*sf
     <-13.008, 4.084, -5.230> , 1*sf
     <-12.529, 3.096, -4.302> , 1*sf
     <-13.591, 3.881, -3.151> , 1*sf
     <-14.235, 5.099, -4.156> , 1*sf
     <-14.950, 6.892, -5.069> , 1*sf
     <-14.965, 8.115, -6.500> , 1*sf
     <-15.666, 9.209, -5.757> , 1*sf
     <-16.182, 9.504, -4.275> , 1*sf
     <-16.345, 11.169, -5.236> , 1*sf
     <-15.904, 12.224, -6.888> , 1*sf
     <-15.272, 12.761, -8.479> , 1*sf
     <-15.828, 14.222, -7.458> , 1*sf
     <-16.092, 15.702, -6.742> , 1*sf
     <-16.633, 14.137, -5.313> , 1*sf
     <-16.990, 13.983, -3.772> , 1*sf
     <-16.903, 15.765, -3.989> , 1*sf
     <-16.477, 16.942, -5.413> , 1*sf
     <-15.722, 18.498, -6.650> , 1*sf
     <-15.098, 20.166, -6.974> , 1*sf
     <-15.732, 20.369, -5.022> , 1*sf
     <-16.477, 19.060, -3.752> , 1*sf
     <-15.802, 21.231, -3.361> , 1*sf
     <-14.918, 22.655, -4.321> , 1*sf
     <-13.922, 24.026, -5.034> , 1*sf
     <-14.024, 24.527, -3.536> , 1*sf
     <-13.525, 25.375, -2.496> , 1*sf
     <-14.911, 23.562, -1.739> , 1*sf
     <-15.243, 23.147, -0.345> , 1*sf
     <-14.531, 24.256, 0.506> , 1*sf
     <-13.699, 25.410, -0.620> , 1*sf
     <-12.481, 26.652, -1.321> , 1*sf
     <-11.262, 27.494, -2.522> , 1*sf
     <-9.683, 28.147, -3.767> , 1*sf
     <-9.967, 28.375, -2.253> , 1*sf
     <-10.476, 28.177, -0.723> , 1*sf
     <-9.598, 28.601, 0.814> , 1*sf
     <-11.035, 27.775, 0.819> , 1*sf
     <-12.266, 26.936, 0.527> , 1*sf
     <-12.540, 26.451, 2.009> , 1*sf
     <-11.025, 27.529, 2.735> , 1*sf
     <-9.435, 28.395, 2.866> , 1*sf
     <-7.667, 29.057, 2.549> , 1*sf
     <-6.412, 29.399, 1.160> , 1*sf
     <-5.177, 29.538, -0.097> , 1*sf
     <-4.244, 29.325, 1.130> , 1*sf
     <-5.224, 29.278, 2.429> , 1*sf
     <-5.828, 28.887, 4.162> , 1*sf
     <-4.053, 28.404, 5.051> , 1*sf
     <-3.552, 28.922, 3.313> , 1*sf
     <-2.542, 28.782, 2.013> , 1*sf
     <-1.041, 28.247, 1.428> , 1*sf
     <-0.097, 27.743, 0.046> , 1*sf
     <-0.124, 27.639, -1.882> , 1*sf
     <-1.196, 28.127, -3.238> , 1*sf
     <-2.420, 28.792, -2.523> , 1*sf
     <-1.669, 28.589, -1.102> , 1*sf
     <-2.227, 28.891, 0.211> , 1*sf
     <-3.582, 29.293, -0.770> , 1*sf
     <-4.607, 29.321, -2.373> , 1*sf
     <-6.114, 29.278, -3.071> , 1*sf
     <-6.255, 29.540, -1.665> , 1*sf
     <-6.826, 29.428, -0.365> , 1*sf
     <-8.010, 29.245, 0.646> , 1*sf
     <-8.708, 28.951, -0.924> , 1*sf
     <-7.769, 29.161, -2.687> , 1*sf
     <-7.624, 28.754, -4.295> , 1*sf
     <-6.783, 28.409, -5.808> , 1*sf
     <-8.505, 28.153, -5.491> , 1*sf
     <-9.960, 27.489, -5.544> , 1*sf
     <-10.910, 26.377, -6.438> , 1*sf
     <-11.183, 26.841, -5.070> , 1*sf
     <-11.877, 26.941, -3.748> , 1*sf
     <-12.740, 25.834, -4.011> , 1*sf
     <-12.541, 25.358, -5.654> , 1*sf
     <-12.187, 24.859, -7.289> , 1*sf
     <-10.868, 25.413, -8.071> , 1*sf
     <-9.423, 24.989, -9.906> , 1*sf
     <-10.940, 24.434, -9.258> , 1*sf
     <-12.062, 23.467, -9.119> , 1*sf
     <-12.532, 22.007, -9.779> , 1*sf
     <-13.087, 23.322, -7.709> , 1*sf
     <-14.008, 23.085, -6.378> , 1*sf
     <-14.733, 21.753, -6.223> , 1*sf
     <-13.954, 21.651, -8.076> , 1*sf
     <-13.525, 20.804, -9.361> , 1*sf
     <-13.274, 19.604, -10.342> , 1*sf
     <-12.265, 20.135, -11.281> , 1*sf
     <-11.082, 19.718, -12.429> , 1*sf
     <-11.178, 18.070, -12.889> , 1*sf
     <-12.417, 18.435, -11.777> , 1*sf
     <-13.360, 17.556, -11.002> , 1*sf
     <-14.208, 16.348, -10.216> , 1*sf
     <-14.200, 18.296, -9.701> , 1*sf
     <-14.704, 19.003, -8.493> , 1*sf
     <-15.354, 17.318, -8.094> , 1*sf
     <-15.121, 15.772, -8.830> , 1*sf
     <-14.693, 14.314, -9.583> , 1*sf
     <-13.809, 13.392, -10.813> , 1*sf
     <-11.871, 12.592, -12.685> , 1*sf
     <-12.797, 11.820, -11.612> , 1*sf
     <-13.897, 11.787, -10.395> , 1*sf
     <-13.859, 10.398, -9.981> , 1*sf
     <-14.767, 11.186, -8.843> , 1*sf
     <-15.500, 10.826, -7.336> , 1*sf
     <-14.960, 9.479, -7.610> , 1*sf
     <-14.117, 9.058, -8.900> , 1*sf
     <-12.820, 7.667, -9.666> , 1*sf
     <-13.811, 7.540, -8.242> , 1*sf
     <-14.057, 6.726, -7.041> , 1*sf
     <-12.940, 5.677, -7.673> , 1*sf
     <-12.401, 6.322, -9.158> , 1*sf
     <-11.250, 6.504, -10.402> , 1*sf
     <-9.916, 5.683, -10.824> , 1*sf
     <-9.388, 6.949, -12.070> , 1*sf
     <-10.296, 8.325, -12.338> , 1*sf
     <-11.491, 8.070, -11.286> , 1*sf
     <-12.739, 9.029, -10.595> , 1*sf
     <-12.705, 10.420, -11.304> , 1*sf
     <-11.521, 10.077, -12.249> , 1*sf
     <-10.275, 10.701, -13.322> , 1*sf
     <-8.750, 11.306, -14.156> , 1*sf
     <-10.570, 12.370, -13.566> , 1*sf
     <-10.677, 13.937, -13.629> , 1*sf
     <-11.825, 14.703, -12.901> , 1*sf
     <-12.881, 14.112, -11.861> , 1*sf
     <-13.292, 15.696, -11.390> , 1*sf
     <-12.121, 16.770, -12.499> , 1*sf
     <-10.708, 16.272, -13.540> , 1*sf
     <-8.950, 16.191, -14.412> , 1*sf
     <-7.236, 16.866, -14.828> , 1*sf
     <-6.104, 18.174, -14.769> , 1*sf
     <-5.879, 16.353, -15.059> , 1*sf
     <-4.158, 15.154, -15.034> , 1*sf
     <-4.797, 13.670, -15.026> , 1*sf
     <-6.340, 14.756, -15.139> , 1*sf
     <-8.040, 14.979, -14.907> , 1*sf
     <-9.342, 14.150, -14.330> , 1*sf
     <-8.750, 12.800, -14.445> , 1*sf
     <-6.982, 13.063, -14.909> , 1*sf
     <-5.606, 11.955, -14.974> , 1*sf
     <-6.349, 10.583, -14.484> , 1*sf
     <-6.390, 8.865, -13.916> , 1*sf
     <-8.040, 9.767, -13.996> , 1*sf
     <-9.302, 9.440, -13.388> , 1*sf
     <-8.333, 7.900, -13.024> , 1*sf
     <-6.767, 7.256, -13.029> , 1*sf
     <-5.556, 6.161, -12.535> , 1*sf
     <-7.368, 5.524, -11.765> , 1*sf
     <-5.687, 4.643, -11.334> , 1*sf
     <-3.646, 5.863, -11.992> , 1*sf
     <-2.988, 7.314, -12.741> , 1*sf
     <-1.481, 7.492, -12.175> , 1*sf
     <0.092, 8.618, -11.665> , 1*sf
     <-0.232, 10.040, -12.581> , 1*sf
     <-1.656, 9.312, -13.194> , 1*sf
     <-3.073, 8.843, -13.570> , 1*sf
     <-4.517, 8.007, -13.420> , 1*sf
     <-4.756, 9.699, -14.204> , 1*sf
     <-4.052, 11.125, -14.527> , 1*sf
     <-2.639, 10.452, -13.954> , 1*sf
     <-1.000, 11.181, -13.462> , 1*sf
     <0.066, 12.881, -13.077> , 1*sf
     <0.165, 14.918, -13.223> , 1*sf
     <-1.031, 14.193, -13.952> , 1*sf
     <-1.288, 12.744, -13.954> , 1*sf
     <-2.652, 12.486, -14.467> , 1*sf
     <-2.682, 14.248, -14.633> , 1*sf
     <-1.870, 15.762, -14.280> , 1*sf
     <-0.255, 16.763, -13.268> , 1*sf
     <-1.315, 18.127, -13.700> , 1*sf
     <-2.290, 20.391, -13.377> , 1*sf
     <-4.037, 20.499, -13.957> , 1*sf
     <-2.942, 19.200, -14.029> , 1*sf
     <-2.658, 17.273, -14.424> , 1*sf
     <-4.161, 17.037, -14.824> , 1*sf
     <-4.567, 18.698, -14.520> , 1*sf
     <-5.463, 20.445, -14.079> , 1*sf
     <-6.685, 21.802, -13.255> , 1*sf
     <-7.482, 23.328, -12.232> , 1*sf
     <-8.249, 22.072, -12.778> , 1*sf
     <-7.724, 20.806, -13.661> , 1*sf
     <-7.840, 19.142, -14.225> , 1*sf
     <-8.789, 17.931, -14.247> , 1*sf
     <-9.743, 18.998, -13.510> , 1*sf
     <-9.249, 20.536, -13.187> , 1*sf
     <-9.866, 21.789, -12.203> , 1*sf
     <-11.291, 21.639, -11.248> , 1*sf
     <-10.739, 23.174, -10.591> , 1*sf
     <-8.983, 23.720, -11.270> , 1*sf
     <-7.543, 24.803, -10.948> , 1*sf
     <-7.473, 25.911, -9.769> , 1*sf
     <-6.100, 27.005, -8.639> , 1*sf
     <-7.786, 26.820, -8.526> , 1*sf
     <-9.338, 26.201, -8.391> , 1*sf
     <-9.118, 27.042, -7.199> , 1*sf
     <-6.950, 27.737, -7.125> , 1*sf
     <-4.871, 27.644, -7.471> , 1*sf
     <-3.165, 27.138, -7.903> , 1*sf
     <-2.449, 27.635, -6.257> , 1*sf
     <-4.229, 28.371, -5.811> , 1*sf
     <-5.529, 28.884, -4.737> , 1*sf
     <-4.112, 28.920, -3.901> , 1*sf
     <-2.387, 28.194, -4.803> , 1*sf
     <-0.688, 27.310, -5.032> , 1*sf
     <-0.210, 26.230, -6.495> , 1*sf
     <-1.551, 26.670, -7.416> , 1*sf
     <-1.899, 25.864, -8.804> , 1*sf
     <-1.632, 24.688, -10.090> , 1*sf
     <-0.370, 25.120, -8.409> , 1*sf
     <-0.134, 23.726, -9.744> , 1*sf
     <-0.728, 22.880, -11.022> , 1*sf
     <-2.173, 23.238, -11.625> , 1*sf
     <-3.866, 23.436, -12.152> , 1*sf
     <-3.254, 24.689, -11.236> , 1*sf
     <-3.254, 25.549, -10.087> , 1*sf
     <-4.454, 26.573, -9.048> , 1*sf
     <-5.794, 25.914, -10.116> , 1*sf
     <-5.206, 24.716, -11.273> , 1*sf
     <-5.959, 23.776, -12.104> , 1*sf
     <-5.206, 22.380, -13.021> , 1*sf
     <-3.372, 22.100, -12.909> , 1*sf
     <-1.467, 21.897, -12.170> , 1*sf
     <0.037, 20.527, -11.855> , 1*sf
     <-0.362, 19.043, -12.770> , 1*sf
     <-0.362, 19.043, -12.770> , 1*sf
     tolerance 0.000001
     }


#declare brain_right =
sphere_sweep {
     cubic_spline
     299,
     <0.362, 14.923, -13.624> , 1*sf
     <0.362, 14.923, -13.624> , 1*sf
     <-0.037, 16.626, -13.249> , 1*sf
     <1.467, 17.815, -13.998> , 1*sf
     <3.372, 17.763, -14.763> , 1*sf
     <5.206, 17.990, -14.962> , 1*sf
     <5.959, 19.611, -14.556> , 1*sf
     <5.206, 20.772, -14.082> , 1*sf
     <5.794, 22.285, -13.385> , 1*sf
     <4.454, 23.259, -12.594> , 1*sf
     <3.254, 21.950, -13.237> , 1*sf
     <3.254, 20.759, -14.038> , 1*sf
     <3.866, 19.274, -14.489> , 1*sf
     <2.173, 19.261, -13.926> , 1*sf
     <0.728, 19.122, -13.239> , 1*sf
     <0.134, 20.342, -12.311> , 1*sf
     <0.370, 22.099, -11.511> , 1*sf
     <1.632, 21.136, -12.955> , 1*sf
     <1.899, 22.670, -12.130> , 1*sf
     <1.551, 23.889, -11.085> , 1*sf
     <0.210, 23.778, -10.071> , 1*sf
     <0.688, 25.279, -9.046> , 1*sf
     <2.387, 26.189, -9.120> , 1*sf
     <4.112, 27.172, -8.509> , 1*sf
     <5.529, 26.863, -9.286> , 1*sf
     <4.229, 26.024, -10.130> , 1*sf
     <2.449, 25.182, -10.309> , 1*sf
     <3.165, 24.170, -11.699> , 1*sf
     <4.871, 24.790, -11.458> , 1*sf
     <6.950, 24.992, -11.162> , 1*sf
     <9.118, 24.312, -11.003> , 1*sf
     <9.338, 23.125, -11.851> , 1*sf
     <7.786, 23.665, -12.182> , 1*sf
     <6.100, 23.802, -12.350> , 1*sf
     <7.473, 22.397, -13.056> , 1*sf
     <7.543, 20.961, -13.803> , 1*sf
     <8.983, 19.833, -13.750> , 1*sf
     <10.739, 19.542, -12.929> , 1*sf
     <11.291, 17.876, -13.043> , 1*sf
     <9.866, 17.703, -13.995> , 1*sf
     <9.249, 16.195, -14.509> , 1*sf
     <9.743, 14.637, -14.307> , 1*sf
     <8.789, 13.386, -14.652> , 1*sf
     <7.840, 14.537, -15.030> , 1*sf
     <7.724, 16.294, -15.046> , 1*sf
     <8.249, 17.780, -14.630> , 1*sf
     <7.482, 19.145, -14.529> , 1*sf
     <6.685, 17.368, -14.991> , 1*sf
     <5.463, 15.815, -15.322> , 1*sf
     <4.567, 14.020, -15.162> , 1*sf
     <4.161, 12.351, -14.902> , 1*sf
     <2.658, 12.706, -14.601> , 1*sf
     <2.942, 14.656, -14.865> , 1*sf
     <4.037, 15.906, -15.225> , 1*sf
     <2.290, 15.995, -14.641> , 1*sf
     <1.315, 13.751, -14.199> , 1*sf
     <0.255, 12.606, -13.342> , 1*sf
     <1.870, 11.327, -13.967> , 1*sf
     <2.682, 9.782, -13.801> , 1*sf
     <2.652, 8.173, -13.063> , 1*sf
     <1.288, 8.586, -12.664> , 1*sf
     <1.031, 9.955, -13.140> , 1*sf
     <-0.165, 10.880, -12.691> , 1*sf
     <-0.066, 9.004, -11.881> , 1*sf
     <1.000, 7.273, -11.685> , 1*sf
     <2.639, 6.423, -11.908> , 1*sf
     <4.052, 6.869, -12.671> , 1*sf
     <4.756, 5.629, -11.896> , 1*sf
     <4.517, 4.290, -10.597> , 1*sf
     <3.073, 5.030, -11.015> , 1*sf
     <1.656, 5.597, -10.815> , 1*sf
     <0.232, 6.486, -10.476> , 1*sf
     <-0.092, 5.446, -9.143> , 1*sf
     <1.481, 4.215, -9.252> , 1*sf
     <2.988, 3.860, -9.728> , 1*sf
     <3.646, 2.737, -8.543> , 1*sf
     <5.687, 1.802, -7.519> , 1*sf
     <7.368, 2.492, -8.216> , 1*sf
     <5.556, 2.840, -9.154> , 1*sf
     <6.767, 3.710, -9.981> , 1*sf
     <8.333, 4.320, -10.189> , 1*sf
     <9.302, 5.654, -11.040> , 1*sf
     <8.040, 5.762, -11.722> , 1*sf
     <6.390, 4.936, -11.349> , 1*sf
     <6.349, 6.371, -12.452> , 1*sf
     <5.606, 7.504, -13.366> , 1*sf
     <6.982, 8.572, -13.671> , 1*sf
     <8.750, 8.477, -13.146> , 1*sf
     <9.342, 9.790, -13.483> , 1*sf
     <8.040, 10.382, -14.301> , 1*sf
     <6.340, 10.094, -14.446> , 1*sf
     <4.797, 9.107, -13.982> , 1*sf
     <4.158, 10.505, -14.478> , 1*sf
     <5.879, 11.628, -14.898> , 1*sf
     <6.104, 13.444, -15.224> , 1*sf
     <7.236, 12.189, -14.848> , 1*sf
     <8.950, 11.689, -14.233> , 1*sf
     <10.708, 12.053, -13.437> , 1*sf
     <12.121, 12.866, -12.618> , 1*sf
     <13.292, 12.218, -11.217> , 1*sf
     <12.881, 10.568, -11.139> , 1*sf
     <11.825, 10.782, -12.316> , 1*sf
     <10.677, 9.820, -12.751> , 1*sf
     <10.570, 8.361, -12.174> , 1*sf
     <8.750, 7.162, -12.380> , 1*sf
     <10.275, 6.866, -11.393> , 1*sf
     <11.521, 6.631, -10.175> , 1*sf
     <12.705, 7.266, -9.396> , 1*sf
     <12.739, 6.187, -8.268> , 1*sf
     <11.491, 5.053, -8.604> , 1*sf
     <10.296, 4.947, -9.681> , 1*sf
     <9.388, 3.736, -8.975> , 1*sf
     <9.916, 2.953, -7.380> , 1*sf
     <11.250, 3.867, -7.253> , 1*sf
     <12.401, 4.105, -6.018> , 1*sf
     <12.940, 3.986, -4.403> , 1*sf
     <14.057, 5.185, -4.153> , 1*sf
     <13.811, 5.557, -5.555> , 1*sf
     <12.820, 5.207, -6.941> , 1*sf
     <14.117, 6.773, -6.677> , 1*sf
     <14.960, 7.596, -5.599> , 1*sf
     <15.500, 8.958, -5.783> , 1*sf
     <14.767, 8.800, -7.325> , 1*sf
     <13.859, 7.682, -8.140> , 1*sf
     <13.897, 8.857, -8.988> , 1*sf
     <12.797, 8.486, -10.149> , 1*sf
     <11.871, 8.861, -11.416> , 1*sf
     <13.809, 10.233, -9.912> , 1*sf
     <14.693, 11.510, -9.055> , 1*sf
     <15.121, 13.134, -8.826> , 1*sf
     <15.354, 14.837, -8.640> , 1*sf
     <14.704, 16.296, -9.573> , 1*sf
     <14.200, 15.230, -10.480> , 1*sf
     <14.208, 13.221, -10.324> , 1*sf
     <13.360, 14.102, -11.465> , 1*sf
     <12.417, 14.676, -12.486> , 1*sf
     <11.178, 13.965, -13.415> , 1*sf
     <11.082, 15.672, -13.525> , 1*sf
     <12.265, 16.445, -12.579> , 1*sf
     <13.274, 16.253, -11.517> , 1*sf
     <13.525, 17.710, -10.986> , 1*sf
     <13.954, 18.934, -10.053> , 1*sf
     <14.733, 19.640, -8.337> , 1*sf
     <14.008, 20.847, -8.922> , 1*sf
     <13.087, 20.632, -10.257> , 1*sf
     <12.532, 18.707, -11.778> , 1*sf
     <12.062, 20.304, -11.636> , 1*sf
     <10.940, 21.170, -12.086> , 1*sf
     <9.423, 21.481, -12.882> , 1*sf
     <10.868, 22.486, -11.289> , 1*sf
     <12.187, 22.221, -10.368> , 1*sf
     <12.541, 23.232, -8.989> , 1*sf
     <12.740, 24.223, -7.594> , 1*sf
     <11.877, 25.355, -7.712> , 1*sf
     <11.183, 24.824, -8.926> , 1*sf
     <10.910, 23.935, -10.065> , 1*sf
     <9.960, 25.280, -9.587> , 1*sf
     <8.505, 25.924, -9.756> , 1*sf
     <6.783, 26.061, -10.141> , 1*sf
     <7.624, 26.886, -8.826> , 1*sf
     <7.769, 27.801, -7.442> , 1*sf
     <8.708, 28.184, -5.709> , 1*sf
     <8.010, 28.979, -4.322> , 1*sf
     <6.826, 28.818, -5.338> , 1*sf
     <6.255, 28.495, -6.602> , 1*sf
     <6.114, 27.784, -7.843> , 1*sf
     <4.607, 28.055, -7.198> , 1*sf
     <3.582, 28.557, -5.676> , 1*sf
     <2.227, 28.501, -4.616> , 1*sf
     <1.669, 27.783, -5.758> , 1*sf
     <2.420, 27.506, -7.166> , 1*sf
     <1.196, 26.642, -7.621> , 1*sf
     <0.124, 26.629, -6.180> , 1*sf
     <0.097, 27.364, -4.394> , 1*sf
     <1.041, 28.295, -3.255> , 1*sf
     <2.542, 28.993, -2.879> , 1*sf
     <3.552, 29.554, -1.698> , 1*sf
     <4.053, 29.638, 0.112> , 1*sf
     <5.828, 29.801, -0.885> , 1*sf
     <5.224, 29.598, -2.650> , 1*sf
     <4.244, 29.214, -3.892> , 1*sf
     <5.177, 29.010, -5.122> , 1*sf
     <6.412, 29.295, -3.888> , 1*sf
     <7.667, 29.429, -2.464> , 1*sf
     <9.435, 28.909, -1.946> , 1*sf
     <11.025, 28.048, -1.784> , 1*sf
     <12.540, 26.791, -2.114> , 1*sf
     <12.266, 26.760, -3.673> , 1*sf
     <11.035, 27.649, -3.674> , 1*sf
     <9.598, 28.427, -3.952> , 1*sf
     <10.476, 27.519, -5.263> , 1*sf
     <9.967, 27.202, -6.773> , 1*sf
     <9.683, 26.487, -8.127> , 1*sf
     <11.262, 26.281, -6.736> , 1*sf
     <12.481, 25.882, -5.325> , 1*sf
     <13.699, 24.941, -4.253> , 1*sf
     <14.531, 24.224, -2.809> , 1*sf
     <15.243, 22.895, -3.248> , 1*sf
     <14.911, 22.827, -4.700> , 1*sf
     <13.525, 24.289, -6.013> , 1*sf
     <14.024, 23.145, -6.715> , 1*sf
     <13.922, 22.179, -7.965> , 1*sf
     <14.918, 21.119, -6.839> , 1*sf
     <15.802, 20.092, -5.463> , 1*sf
     <16.477, 17.914, -5.116> , 1*sf
     <15.732, 18.731, -6.746> , 1*sf
     <15.098, 17.895, -8.522> , 1*sf
     <15.722, 16.427, -7.666> , 1*sf
     <16.477, 15.366, -5.986> , 1*sf
     <16.903, 14.724, -4.253> , 1*sf
     <16.990, 13.114, -3.460> , 1*sf
     <16.633, 12.751, -4.966> , 1*sf
     <16.092, 13.757, -6.831> , 1*sf
     <15.828, 12.123, -7.019> , 1*sf
     <15.272, 10.408, -7.501> , 1*sf
     <15.904, 10.426, -5.822> , 1*sf
     <16.345, 9.974, -3.914> , 1*sf
     <16.182, 8.720, -2.458> , 1*sf
     <15.666, 7.952, -3.760> , 1*sf
     <14.965, 6.674, -4.100> , 1*sf
     <14.950, 5.991, -2.346> , 1*sf
     <14.235, 4.601, -0.893> , 1*sf
     <13.591, 3.782, 0.456> , 1*sf
     <12.529, 2.661, -0.370> , 1*sf
     <13.008, 3.288, -1.572> , 1*sf
     <13.783, 4.304, -2.636> , 1*sf
     <12.183, 2.664, -2.941> , 1*sf
     <10.519, 1.452, -2.601> , 1*sf
     <9.092, 0.652, -1.887> , 1*sf
     <8.535, 0.586, -3.203> , 1*sf
     <9.941, 1.473, -4.156> , 1*sf
     <11.175, 2.526, -4.713> , 1*sf
     <10.040, 2.184, -5.875> , 1*sf
     <8.450, 1.809, -6.602> , 1*sf
     <7.773, 1.026, -5.194> , 1*sf
     <6.344, 0.404, -4.092> , 1*sf
     <4.664, 0.704, -4.768> , 1*sf
     <6.246, 1.083, -5.867> , 1*sf
     <4.271, 1.358, -6.312> , 1*sf
     <2.557, 2.195, -7.047> , 1*sf
     <1.638, 3.128, -7.860> , 1*sf
     <0.030, 3.879, -7.281> , 1*sf
     <0.039, 2.787, -5.274> , 1*sf
     <1.504, 2.085, -5.905> , 1*sf
     <2.736, 1.212, -4.975> , 1*sf
     <1.665, 1.230, -3.884> , 1*sf
     <0.117, 2.019, -3.293> , 1*sf
     <0.555, 1.367, -1.375> , 1*sf
     <2.169, 0.624, -1.706> , 1*sf
     <3.507, 0.374, -2.970> , 1*sf
     <4.720, -0.057, -1.443> , 1*sf
     <4.861, -0.118, 0.573> , 1*sf
     <6.401, -0.125, 0.161> , 1*sf
     <6.459, -0.085, -1.359> , 1*sf
     <5.531, 0.072, -2.725> , 1*sf
     <8.012, 0.094, 0.020> , 1*sf
     <9.647, 0.734, 0.666> , 1*sf
     <11.077, 1.540, -0.968> , 1*sf
     <11.272, 1.695, 0.811> , 1*sf
     <11.489, 2.047, 2.593> , 1*sf
     <11.899, 2.659, 4.135> , 1*sf
     <12.864, 3.761, 4.405> , 1*sf
     <12.736, 2.988, 1.944> , 1*sf
     <13.748, 4.232, 2.714> , 1*sf
     <14.644, 5.769, 3.455> , 1*sf
     <15.578, 7.328, 3.096> , 1*sf
     <15.418, 6.567, 1.728> , 1*sf
     <14.594, 5.181, 1.370> , 1*sf
     <15.202, 6.083, -0.044> , 1*sf
     <15.674, 7.146, -1.353> , 1*sf
     <16.089, 8.001, 0.069> , 1*sf
     <16.569, 9.261, 0.927> , 1*sf
     <16.983, 11.094, 1.160> , 1*sf
     <17.016, 11.111, -0.393> , 1*sf
     <16.665, 9.726, -0.992> , 1*sf
     <16.776, 10.636, -2.222> , 1*sf
     <16.673, 11.415, -3.919> , 1*sf
     <17.092, 12.212, -2.190> , 1*sf
     <17.307, 13.688, -1.103> , 1*sf
     <17.411, 15.008, 0.139> , 1*sf
     <17.280, 16.646, -0.623> , 1*sf
     <17.265, 15.162, -2.117> , 1*sf
     <17.087, 16.327, -3.134> , 1*sf
     <17.029, 17.645, -2.395> , 1*sf
     <16.938, 18.733, -1.017> , 1*sf
     <16.592, 20.294, -0.654> , 1*sf
     <16.546, 20.079, -2.235> , 1*sf
     <16.608, 19.045, -3.524> , 1*sf
     <16.107, 20.372, -3.969> , 1*sf
     <15.492, 21.473, -4.993> , 1*sf
     <15.850, 21.686, -2.790> , 1*sf
     <15.691, 22.464, -1.368> , 1*sf
     <15.019, 23.805, -0.672> , 1*sf
     <14.783, 24.127, 1.054> , 1*sf
     <14.067, 25.361, 1.078> , 1*sf
     <14.051, 25.310, -0.571> , 1*sf
     <13.668, 25.592, -2.062> , 1*sf
     <12.890, 26.567, -0.094> , 1*sf
     <12.890, 26.567, -0.094> , 1*sf
     tolerance 0.000001
     }


// -----------------------------------------------------------------------------------------
//                     T E N T A C L E  -   W E A P O N
//------------------------------------------------------------------------------------------
#declare lathe_weapon_body =
lathe{ 
      cubic_spline
      31,
     <-0.000, 0.000>,
     <-0.000, 0.000>,
     <0.360, 0.000>,
     <1.376, 0.000>,
     <1.645, 0.088>,
     <1.867, 0.275>,
     <2.250, 1.272>,
     <2.536, 2.671>,
     <2.575, 4.508>,
     <2.739, 4.826>,
     <2.796, 4.968>,
     <3.139, 5.190>,
     <4.517, 6.322>,
     <5.851, 8.181>,
     <6.853, 10.610>,
     <7.304, 13.211>,
     <7.325, 13.524>,
     <7.573, 13.633>,
     <7.797, 13.912>,
     <8.033, 14.956>,
     <7.797, 15.914>,
     <7.508, 16.071>,
     <7.495, 16.373>,
     <7.116, 16.484>,
     <7.029, 16.769>,
     <6.375, 17.726>,
     <4.627, 18.781>,
     <2.327, 19.411>,
     <0.198, 19.595>,
     <-0.000, 19.601>,
     <-0.000, 19.601>
      }



#declare blade = 
#difference {
    union {
        difference {
            //cylinder {<0,0,-4>,<0,0,4>, 1 scale <11,22,1> translate <0,18.7,0> }
            sphere { <0,0,0>,1 scale <11,22,5> translate <0,18.7,0>}
            cylinder {<0,0,-5>,<0,0,5>, 1 scale <9,24.6,1> translate <0,21,0> }
            }
        cylinder {<0,0,-4>,<0,0,4>, 1 scale <9,5.1,1> translate <0,14,0> } 
    } 
    plane {<0,0,1>,0 rotate <3,0,0> translate <6,36,0> }   
    plane {<0,0,-1>,0 rotate <-3,0,0>  translate <6,36,0> } 
    cylinder {<0,0,-5>,<0,0,5>, 1 scale <11,9,1> translate <0,0,0> } 
}
  

#declare button = sphere {<0,0,0>, 1 scale <1,3,1.3> translate < 7.2,14,0 >        }
#declare slot = box {<-.1,-5,-15>,<.1,5,15> }    
#declare weapon_body =
union {
    
    #difference {
        object { lathe_weapon_body material {_m_metal}}    
        plane { <0,-1,0>,0 translate <0,16.5,0> }
        sphere { <0,0,0>, 6.85 translate <0,16.5,0>}
        material {_m_metal}
    }
    
    #difference {
        sphere { <0,0,0>, 1 scale<6.5,3,6.5> material {_m_metal} }
        #for (i,0,15)
            object { slot rotate <0,i*24,0> material {M_black_gloss} }
        #end
        sphere { <0,0,0>, 1 scale<3,3,3> translate <0,3,0> material {_m_metal} }
        translate <0,16.5,0> 
     }
       
    #difference {
        object { sphere { <0,0,0>, 1 scale<6.25,2.9,6.25> material {M_violet_glow}  }}
        sphere { <0,0,0>, 1 scale<2.7,2,2.7> translate <0,3,0> material {_m_metal} }
        translate <0,16.5,0> 
    }
    
    sphere { <0,0,0>, 1 scale<2.4,1,2.4> translate <0,3,0> material {_m_metal} }
    object { blade rotate <0,0,0>  translate <0,-1,0> material {_m_metal}} 
    object { blade rotate <0,90,0> translate <0,-1,0> material {_m_metal}} 
    #for (i,0,7)
        object { button rotate <0,i*45,0> material {_m_metal}}
    #end
}    


// -----------------------------------------------------------------------------------------
//                     T E N T A C L E  -  A R M   L E F T
//------------------------------------------------------------------------------------------


#declare sf=1.8;
#declare arm_left_sweep =
sphere_sweep {
     cubic_spline
     47,
     <-20.956, -9.051, -2.901> , 1.679 * sf
     <-20.956, -9.051, -2.901> , 1.679 * sf
     <-24.148, -9.552, -2.901> , 1.442 * sf
     <-27.279, -10.307, -2.939> , 1.200 * sf
     <-30.327, -11.320, -3.060> , 1.000 * sf
     <-33.266, -12.577, -3.302> , 1.000 * sf
     <-36.060, -14.079, -3.704> , 1.000 * sf
     <-38.659, -15.822, -4.302> ,  1.000 * sf
     <-41.001, -17.802, -5.127> ,  1.000 * sf
     <-43.015, -19.996, -6.201> ,  1.000 * sf
     <-44.638, -22.362, -7.529> ,  1.000 * sf
     <-45.837, -24.856, -9.078> ,  1.000 * sf
     <-46.619, -27.455, -10.749> ,  1.000 * sf
     <-47.001, -30.139, -12.443> ,  1.000 * sf
     <-46.980, -32.861, -14.117> ,  1.000 * sf
     <-46.545, -35.569, -15.751> ,  1.000 * sf
     <-45.683, -38.204, -17.319> ,  1.000 * sf
     <-44.370, -40.693, -18.790> ,  1.000 * sf
     <-42.587, -42.940, -20.118> ,  1.000 * sf
     <-40.335, -44.823, -21.247> ,  1.000 * sf
     <-37.664, -46.210, -22.112> ,  1.000 * sf
     <-34.689, -47.007, -22.670> ,  1.000 * sf
     <-31.555, -47.200, -22.914> ,  1.000 * sf
     <-28.374, -46.926, -22.870> ,  1.000 * sf
     <-25.200, -46.419, -22.541> ,  1.000 * sf
     <-22.048, -45.852, -21.998> ,  1.000 * sf
     <-18.922, -45.266, -21.337> ,  1.000 * sf
     <-15.802, -44.683, -20.644> ,  1.000 * sf
     <-12.668, -44.124, -20.003> ,  1.000 * sf
     <-9.502, -43.615, -19.509> ,  1.000 * sf
     <-6.299, -43.189, -19.282> ,  1.000 * sf
     <-3.088, -42.894, -19.474> ,  1.000 * sf
     <0.035, -42.785, -20.241> ,  1.000 * sf
     <2.922, -42.906, -21.660> ,  1.000 * sf
     <5.368, -43.356, -23.712> ,  1.000 * sf
     <7.114, -44.249, -26.287> ,  1.000 * sf
     <8.098, -45.484, -29.121> ,  1.000 * sf
     <8.425, -46.913, -32.018> ,  1.000 * sf
     <8.214, -48.434, -34.878> ,  1.000 * sf
     <7.528, -49.980, -37.644> ,  1.000 * sf
     <6.387, -51.487, -40.271> ,  1.000 * sf
     <4.999, -52.913, -42.815> ,  1.000 * sf
     <3.624, -54.176, -45.411> ,  1.000 * sf
     <2.271, -55.106, -48.120> , 1.200 * sf
     <0.895, -55.651, -50.935> , 1.442 * sf
     <-0.524, -55.934, -53.803> , 1.679 * sf
     <-0.524, -55.934, -53.803> , 1.679 * sf
     tolerance 0.000001
     }


#declare pointDataCount = 45 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <-20.956, -9.051, -2.901>  ;
#declare pointArray[0][1] = 1.679 ;
#declare pointArray[1][0] = <-24.148, -9.552, -2.901>  ;
#declare pointArray[1][1] = 1.442 ;
#declare pointArray[2][0] = <-27.279, -10.307, -2.939>  ;
#declare pointArray[2][1] = 1.200 ;
#declare pointArray[3][0] = <-30.327, -11.320, -3.060>  ;
#declare pointArray[3][1] = 1.000 ;
#declare pointArray[4][0] = <-33.266, -12.577, -3.302>  ;
#declare pointArray[4][1] = 1.000 ;
#declare pointArray[5][0] = <-36.060, -14.079, -3.704>  ;
#declare pointArray[5][1] = 1.000 ;
#declare pointArray[6][0] = <-38.659, -15.822, -4.302>  ;
#declare pointArray[6][1] = 1.000 ;
#declare pointArray[7][0] = <-41.001, -17.802, -5.127>  ;
#declare pointArray[7][1] = 1.000 ;
#declare pointArray[8][0] = <-43.015, -19.996, -6.201>  ;
#declare pointArray[8][1] = 1.000 ;
#declare pointArray[9][0] = <-44.638, -22.362, -7.529>  ;
#declare pointArray[9][1] = 1.000 ;
#declare pointArray[10][0] = <-45.837, -24.856, -9.078>  ;
#declare pointArray[10][1] = 1.000 ;
#declare pointArray[11][0] = <-46.619, -27.455, -10.749>  ;
#declare pointArray[11][1] = 1.000 ;
#declare pointArray[12][0] = <-47.001, -30.139, -12.443>  ;
#declare pointArray[12][1] = 1.000 ;
#declare pointArray[13][0] = <-46.980, -32.861, -14.117>  ;
#declare pointArray[13][1] = 1.000 ;
#declare pointArray[14][0] = <-46.545, -35.569, -15.751>  ;
#declare pointArray[14][1] = 1.000 ;
#declare pointArray[15][0] = <-45.683, -38.204, -17.319>  ;
#declare pointArray[15][1] = 1.000 ;
#declare pointArray[16][0] = <-44.370, -40.693, -18.790>  ;
#declare pointArray[16][1] = 1.000 ;
#declare pointArray[17][0] = <-42.587, -42.940, -20.118>  ;
#declare pointArray[17][1] = 1.000 ;
#declare pointArray[18][0] = <-40.335, -44.823, -21.247>  ;
#declare pointArray[18][1] = 1.000 ;
#declare pointArray[19][0] = <-37.664, -46.210, -22.112>  ;
#declare pointArray[19][1] = 1.000 ;
#declare pointArray[20][0] = <-34.689, -47.007, -22.670>  ;
#declare pointArray[20][1] = 1.000 ;
#declare pointArray[21][0] = <-31.555, -47.200, -22.914>  ;
#declare pointArray[21][1] = 1.000 ;
#declare pointArray[22][0] = <-28.374, -46.926, -22.870>  ;
#declare pointArray[22][1] = 1.000 ;
#declare pointArray[23][0] = <-25.200, -46.419, -22.541>  ;
#declare pointArray[23][1] = 1.000 ;
#declare pointArray[24][0] = <-22.048, -45.852, -21.998>  ;
#declare pointArray[24][1] = 1.000 ;
#declare pointArray[25][0] = <-18.922, -45.266, -21.337>  ;
#declare pointArray[25][1] = 1.000 ;
#declare pointArray[26][0] = <-15.802, -44.683, -20.644>  ;
#declare pointArray[26][1] = 1.000 ;
#declare pointArray[27][0] = <-12.668, -44.124, -20.003>  ;
#declare pointArray[27][1] = 1.000 ;
#declare pointArray[28][0] = <-9.502, -43.615, -19.509>  ;
#declare pointArray[28][1] = 1.000 ;
#declare pointArray[29][0] = <-6.299, -43.189, -19.282>  ;
#declare pointArray[29][1] = 1.000 ;
#declare pointArray[30][0] = <-3.088, -42.894, -19.474>  ;
#declare pointArray[30][1] = 1.000 ;
#declare pointArray[31][0] = <0.035, -42.785, -20.241>  ;
#declare pointArray[31][1] = 1.000 ;
#declare pointArray[32][0] = <2.922, -42.906, -21.660>  ;
#declare pointArray[32][1] = 1.000 ;
#declare pointArray[33][0] = <5.368, -43.356, -23.712>  ;
#declare pointArray[33][1] = 1.000 ;
#declare pointArray[34][0] = <7.114, -44.249, -26.287>  ;
#declare pointArray[34][1] = 1.000 ;
#declare pointArray[35][0] = <8.098, -45.484, -29.121>  ;
#declare pointArray[35][1] = 1.000 ;
#declare pointArray[36][0] = <8.425, -46.913, -32.018>  ;
#declare pointArray[36][1] = 1.000 ;
#declare pointArray[37][0] = <8.214, -48.434, -34.878>  ;
#declare pointArray[37][1] = 1.000 ;
#declare pointArray[38][0] = <7.528, -49.980, -37.644>  ;
#declare pointArray[38][1] = 1.000 ;
#declare pointArray[39][0] = <6.387, -51.487, -40.271>  ;
#declare pointArray[39][1] = 1.000 ;
#declare pointArray[40][0] = <4.999, -52.913, -42.815>  ;
#declare pointArray[40][1] = 1.000 ;
#declare pointArray[41][0] = <3.624, -54.176, -45.411>  ;
#declare pointArray[41][1] = 1.000 ;
#declare pointArray[42][0] = <2.271, -55.106, -48.120>  ;
#declare pointArray[42][1] = 1.200 ;
#declare pointArray[43][0] = <0.895, -55.651, -50.935>  ;
#declare pointArray[43][1] = 1.442 ;
#declare pointArray[44][0] = <-0.524, -55.934, -53.803>  ;
#declare pointArray[44][1] = 1.679 ;  

#declare node = sphere {<0,0,0> 1} ;
#declare centerPos = <20.956,9.051,0> ;

#declare bot_arm_left = 
union {
    object {
        intersection {
            union {
                #for (i,0,pointDataCount-1)
                    object {node scale pointArray[i][1]*2.2 translate pointArray[i][0] + centerPos}
                #end 
                material {M_black_gloss}
            }         
            object { arm_left_sweep material {_m_metal} translate centerPos }
        }  
        
        rotate <0,-5,-10>
        translate -centerPos
    }      
    // add weapon
    object { weapon_body rotate <-100,0,0> rotate <0,30,0> translate <-5, -59.5, -53>}
}



// -----------------------------------------------------------------------------------------
//                     T E N T A C L E  -  A R M   R I G H T
//------------------------------------------------------------------------------------------

#declare sf=1.8;
#declare arm_right_sweep =
sphere_sweep {
     cubic_spline
     38,
     <22.471, -5.114, 0.261> , 1.679*sf
     <22.471, -5.114, 0.261> , 1.679*sf
     <25.346, -3.740, -0.298> , 1.442*sf
     <28.128, -2.230, -0.948> , 1.200*sf
     <30.789, -0.562, -1.701> ,  1.000 * sf
     <33.298, 1.277, -2.559> ,  1.000 * sf
     <35.618, 3.300, -3.517> ,  1.000 * sf
     <37.708, 5.512, -4.571> ,  1.000 * sf
     <39.518, 7.919, -5.703> ,  1.000 * sf
     <41.003, 10.512, -6.887> ,  1.000 * sf
     <42.107, 13.279, -8.084> ,  1.000 * sf
     <42.795, 16.189, -9.241> ,  1.000 * sf
     <43.029, 19.207, -10.290> ,  1.000 * sf
     <42.794, 22.281, -11.149> ,  1.000 * sf
     <42.063, 25.329, -11.748> ,  1.000 * sf
     <40.781, 28.227, -12.111> ,  1.000 * sf
     <39.011, 30.886, -12.308> ,  1.000 * sf
     <36.869, 33.276, -12.390> ,  1.000 * sf
     <34.451, 35.398, -12.404> ,  1.000 * sf
     <31.819, 37.259, -12.385> ,  1.000 * sf
     <29.021, 38.861, -12.362> ,  1.000 * sf
     <26.089, 40.208, -12.361> ,  1.000 * sf
     <23.050, 41.291, -12.405> ,  1.000 * sf
     <19.928, 42.100, -12.519> ,  1.000 * sf
     <16.751, 42.616, -12.726> ,  1.000 * sf
     <13.548, 42.817, -13.050> ,  1.000 * sf
     <10.347, 42.729, -13.475> ,  1.000 * sf
     <7.170, 42.413, -13.994> ,  1.000 * sf
     <4.044, 41.915, -14.679> ,  1.000 * sf
     <1.007, 41.268, -15.606> ,  1.000 * sf
     <-1.900, 40.514, -16.828> ,  1.000 * sf
     <-4.641, 39.699, -18.363> ,  1.000 * sf
     <-7.193, 38.865, -20.189> ,  1.000 * sf
     <-9.547, 38.042, -22.271> ,  1.000 * sf
     <-11.714, 37.250, -24.560> , 1.200*sf
     <-13.707, 36.500, -27.016> , 1.442*sf
     <-15.547, 35.796, -29.601> , 1.679*sf
     <-15.547, 35.796, -29.601> , 1.679*sf
     tolerance 0.000001
     }


#declare pointDataCount = 35 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <25.346, -3.740, -0.298>  ;
#declare pointArray[0][1] = 1.442 ;
#declare pointArray[1][0] = <28.128, -2.230, -0.948>  ;
#declare pointArray[1][1] = 1.200 ;
#declare pointArray[2][0] = <30.789, -0.562, -1.701>  ;
#declare pointArray[2][1] = 1.000 ;
#declare pointArray[3][0] = <33.298, 1.277, -2.559>  ;
#declare pointArray[3][1] = 1.000 ;
#declare pointArray[4][0] = <35.618, 3.300, -3.517>  ;
#declare pointArray[4][1] = 1.000 ;
#declare pointArray[5][0] = <37.708, 5.512, -4.571>  ;
#declare pointArray[5][1] = 1.000 ;
#declare pointArray[6][0] = <39.518, 7.919, -5.703>  ;
#declare pointArray[6][1] = 1.000 ;
#declare pointArray[7][0] = <41.003, 10.512, -6.887>  ;
#declare pointArray[7][1] = 1.000 ;
#declare pointArray[8][0] = <42.107, 13.279, -8.084>  ;
#declare pointArray[8][1] = 1.000 ;
#declare pointArray[9][0] = <42.795, 16.189, -9.241>  ;
#declare pointArray[9][1] = 1.000 ;
#declare pointArray[10][0] = <43.029, 19.207, -10.290>  ;
#declare pointArray[10][1] = 1.000 ;
#declare pointArray[11][0] = <42.794, 22.281, -11.149>  ;
#declare pointArray[11][1] = 1.000 ;
#declare pointArray[12][0] = <42.063, 25.329, -11.748>  ;
#declare pointArray[12][1] = 1.000 ;
#declare pointArray[13][0] = <40.781, 28.227, -12.111>  ;
#declare pointArray[13][1] = 1.000 ;
#declare pointArray[14][0] = <39.011, 30.886, -12.308>  ;
#declare pointArray[14][1] = 1.000 ;
#declare pointArray[15][0] = <36.869, 33.276, -12.390>  ;
#declare pointArray[15][1] = 1.000 ;
#declare pointArray[16][0] = <34.451, 35.398, -12.404>  ;
#declare pointArray[16][1] = 1.000 ;
#declare pointArray[17][0] = <31.819, 37.259, -12.385>  ;
#declare pointArray[17][1] = 1.000 ;
#declare pointArray[18][0] = <29.021, 38.861, -12.362>  ;
#declare pointArray[18][1] = 1.000 ;
#declare pointArray[19][0] = <26.089, 40.208, -12.361>  ;
#declare pointArray[19][1] = 1.000 ;
#declare pointArray[20][0] = <23.050, 41.291, -12.405>  ;
#declare pointArray[20][1] = 1.000 ;
#declare pointArray[21][0] = <19.928, 42.100, -12.519>  ;
#declare pointArray[21][1] = 1.000 ;
#declare pointArray[22][0] = <16.751, 42.616, -12.726>  ;
#declare pointArray[22][1] = 1.000 ;
#declare pointArray[23][0] = <13.548, 42.817, -13.050>  ;
#declare pointArray[23][1] = 1.000 ;
#declare pointArray[24][0] = <10.347, 42.729, -13.475>  ;
#declare pointArray[24][1] = 1.000 ;
#declare pointArray[25][0] = <7.170, 42.413, -13.994>  ;
#declare pointArray[25][1] = 1.000 ;
#declare pointArray[26][0] = <4.044, 41.915, -14.679>  ;
#declare pointArray[26][1] = 1.000 ;
#declare pointArray[27][0] = <1.007, 41.268, -15.606>  ;
#declare pointArray[27][1] = 1.000 ;
#declare pointArray[28][0] = <-1.900, 40.514, -16.828>  ;
#declare pointArray[28][1] = 1.000 ;
#declare pointArray[29][0] = <-4.641, 39.699, -18.363>  ;
#declare pointArray[29][1] = 1.000 ;
#declare pointArray[30][0] = <-7.193, 38.865, -20.189>  ;
#declare pointArray[30][1] = 1.000 ;
#declare pointArray[31][0] = <-9.547, 38.042, -22.271>  ;
#declare pointArray[31][1] = 1.000 ;
#declare pointArray[32][0] = <-11.714, 37.250, -24.560>  ;
#declare pointArray[32][1] = 1.200 ;
#declare pointArray[33][0] = <-13.707, 36.500, -27.016>  ;
#declare pointArray[33][1] = 1.442 ;
#declare pointArray[34][0] = <-15.547, 35.796, -29.601>  ;
#declare pointArray[34][1] = 1.679 ;
    
#declare node = sphere {<0,0,0> 1} ;    
#declare centerPos = <-22.471, 5.114,0> ;

 
#declare bot_arm_right =  
union {
    object {
        intersection {
            union {
                #for (i,0,pointDataCount-1)
                    object {node scale pointArray[i][1]*2.2 translate pointArray[i][0] + centerPos}
                #end 
                material {M_black_gloss}
            }         
            object { arm_right_sweep material {_m_metal} translate centerPos }  
        }
        rotate <-30,10,-10>
        translate -centerPos   
            
    }
    // add weapon
    object { weapon_body  rotate <0,30,0> rotate <-120,0,0> rotate <0,50,0> translate <-19, 23.2, -39> }
}

// -----------------------------------------------------------------------------------------
//                     T E N T A C L E  -   L E G  L E F T
//------------------------------------------------------------------------------------------

#declare sf=1.8;
#declare sweep_leg_left =
sphere_sweep {
     cubic_spline
     30,
     <-11.421, -23.321, -0.077> , 1.679*sf
     <-11.421, -23.321, -0.077> , 1.679*sf
     <-14.102, -25.010, -0.714> , 1.442*sf
     <-16.655, -26.811, -1.509> , 1.200*sf
     <-19.024, -28.753, -2.505> , 1.000*sf
     <-21.166, -30.835, -3.706> , 1.000*sf
     <-23.038, -33.045, -5.106> , 1.000*sf
     <-24.606, -35.367, -6.685> , 1.000*sf
     <-25.848, -37.778, -8.414> , 1.000*sf
     <-26.756, -40.255, -10.258> , 1.000*sf
     <-27.338, -42.776, -12.174> , 1.000*sf
     <-27.612, -45.326, -14.125> , 1.000*sf
     <-27.599, -47.895, -16.073> , 1.000*sf
     <-27.326, -50.479, -17.986> , 1.000*sf
     <-26.816, -53.078, -19.830> , 1.000*sf
     <-26.092, -55.698, -21.573> , 1.000*sf
     <-25.171, -58.345, -23.175> , 1.000*sf
     <-24.073, -61.034, -24.589> , 1.000*sf
     <-22.884, -63.805, -25.768> , 1.000*sf
     <-21.790, -66.717, -26.699> , 1.000*sf
     <-20.863, -69.747, -27.422> , 1.000*sf
     <-20.092, -72.855, -27.984> , 1.000*sf
     <-19.466, -76.017, -28.418> , 1.000*sf
     <-18.979, -79.215, -28.755> , 1.000*sf
     <-18.634, -82.439, -29.022> , 1.000*sf
     <-18.441, -85.681, -29.246> , 1.000*sf
     <-18.427, -88.932, -29.459> , 1.200*sf
     <-18.649, -92.177, -29.709> , 1.442*sf
     <-19.234, -95.372, -30.094> , 1.679*sf
     <-19.234, -95.372, -30.094> , 1.679*sf
     tolerance 0.000001
     }

#declare pointDataCount = 28 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <-11.421, -23.321, -0.077>  ;
#declare pointArray[0][1] = 1.679 ;
#declare pointArray[1][0] = <-14.102, -25.010, -0.714>  ;
#declare pointArray[1][1] = 1.442 ;
#declare pointArray[2][0] = <-16.655, -26.811, -1.509>  ;
#declare pointArray[2][1] = 1.200 ;
#declare pointArray[3][0] = <-19.024, -28.753, -2.505>  ;
#declare pointArray[3][1] = 1.000 ;
#declare pointArray[4][0] = <-21.166, -30.835, -3.706>  ;
#declare pointArray[4][1] = 1.000 ;
#declare pointArray[5][0] = <-23.038, -33.045, -5.106>  ;
#declare pointArray[5][1] = 1.000 ;
#declare pointArray[6][0] = <-24.606, -35.367, -6.685>  ;
#declare pointArray[6][1] = 1.000 ;
#declare pointArray[7][0] = <-25.848, -37.778, -8.414>  ;
#declare pointArray[7][1] = 1.000 ;
#declare pointArray[8][0] = <-26.756, -40.255, -10.258>  ;
#declare pointArray[8][1] = 1.000 ;
#declare pointArray[9][0] = <-27.338, -42.776, -12.174>  ;
#declare pointArray[9][1] = 1.000 ;
#declare pointArray[10][0] = <-27.612, -45.326, -14.125>  ;
#declare pointArray[10][1] = 1.000 ;
#declare pointArray[11][0] = <-27.599, -47.895, -16.073>  ;
#declare pointArray[11][1] = 1.000 ;
#declare pointArray[12][0] = <-27.326, -50.479, -17.986>  ;
#declare pointArray[12][1] = 1.000 ;
#declare pointArray[13][0] = <-26.816, -53.078, -19.830>  ;
#declare pointArray[13][1] = 1.000 ;
#declare pointArray[14][0] = <-26.092, -55.698, -21.573>  ;
#declare pointArray[14][1] = 1.000 ;
#declare pointArray[15][0] = <-25.171, -58.345, -23.175>  ;
#declare pointArray[15][1] = 1.000 ;
#declare pointArray[16][0] = <-24.073, -61.034, -24.589>  ;
#declare pointArray[16][1] = 1.000 ;
#declare pointArray[17][0] = <-22.884, -63.805, -25.768>  ;
#declare pointArray[17][1] = 1.000 ;
#declare pointArray[18][0] = <-21.790, -66.717, -26.699>  ;
#declare pointArray[18][1] = 1.000 ;
#declare pointArray[19][0] = <-20.863, -69.747, -27.422>  ;
#declare pointArray[19][1] = 1.000 ;
#declare pointArray[20][0] = <-20.092, -72.855, -27.984>  ;
#declare pointArray[20][1] = 1.000 ;
#declare pointArray[21][0] = <-19.466, -76.017, -28.418>  ;
#declare pointArray[21][1] = 1.000 ;
#declare pointArray[22][0] = <-18.979, -79.215, -28.755>  ;
#declare pointArray[22][1] = 1.000 ;
#declare pointArray[23][0] = <-18.634, -82.439, -29.022>  ;
#declare pointArray[23][1] = 1.000 ;
#declare pointArray[24][0] = <-18.441, -85.681, -29.246>  ;
#declare pointArray[24][1] = 1.000 ;
#declare pointArray[25][0] = <-18.427, -88.932, -29.459>  ;
#declare pointArray[25][1] = 1.200 ;
#declare pointArray[26][0] = <-18.649, -92.177, -29.709>  ;
#declare pointArray[26][1] = 1.442 ;
#declare pointArray[27][0] = <-19.234, -95.372, -30.094>  ;
#declare pointArray[27][1] = 1.679 ;



#declare node = sphere {<0,0,0> 1} ;    
#declare centerPos = <11.421, 23.321, 0> ;

  
#declare bot_leg_left = 
object {
    intersection {
        union {
            #for (i,0,pointDataCount-1)
                object {node scale pointArray[i][1]*2.2 translate pointArray[i][0] + centerPos}
            #end 
            material {M_black_gloss}
        }         
        object { sweep_leg_left material {_m_metal} translate centerPos} 
        }  
    rotate <0,0,5>    
    translate -centerPos    
}


// -----------------------------------------------------------------------------------------
//                     T E N T A C L E  -   L E G   R I G H T
//------------------------------------------------------------------------------------------

#declare sf=1.8;
#declare leg_right_sweep =
sphere_sweep {
     cubic_spline
     29,
     <14.198, -23.202, 1.786> , 1.679*sf
     <14.198, -23.202, 1.786> , 1.679*sf
     <16.911, -24.952, 2.606> , 1.442*sf
     <19.354, -27.023, 3.507> , 1.200*sf
     <21.494, -29.371, 4.476> ,  1.000*sf
     <23.320, -31.941, 5.501> ,  1.000*sf
     <24.834, -34.676, 6.571> ,  1.000*sf
     <26.057, -37.530, 7.678> ,  1.000*sf
     <27.011, -40.462, 8.818> ,  1.000*sf
     <27.720, -43.442, 9.988> ,  1.000*sf
     <28.205, -46.445, 11.190> ,  1.000*sf
     <28.484, -49.451, 12.429> ,  1.000*sf
     <28.573, -52.443, 13.711> ,  1.000*sf
     <28.480, -55.402, 15.044> ,  1.000*sf
     <28.204, -58.318, 16.448> ,  1.000*sf
     <27.711, -61.230, 17.900> ,  1.000*sf
     <26.962, -64.160, 19.279> ,  1.000*sf
     <26.011, -67.069, 20.544> ,  1.000*sf
     <24.909, -69.948, 21.714> ,  1.000*sf
     <23.688, -72.799, 22.807> ,  1.000*sf
     <22.371, -75.623, 23.837> ,  1.000*sf
     <20.968, -78.421, 24.811> ,  1.000*sf
     <19.490, -81.192, 25.736> ,  1.000*sf
     <17.939, -83.938, 26.616> ,  1.000*sf
     <16.314, -86.655, 27.452> ,  1.000*sf
     <14.605, -89.338, 28.242> , 1.200*sf
     <12.788, -91.973, 28.979> , 1.442*sf
     <10.907, -94.549, 29.673> , 1.679*sf
     <10.907, -94.549, 29.673> , 1.679*sf
     tolerance 0.000001
     }


#declare pointDataCount = 27 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <14.198, -23.202, 1.786>  ;
#declare pointArray[0][1] = 1.679 ;
#declare pointArray[1][0] = <16.911, -24.952, 2.606>  ;
#declare pointArray[1][1] = 1.442 ;
#declare pointArray[2][0] = <19.354, -27.023, 3.507>  ;
#declare pointArray[2][1] = 1.200 ;
#declare pointArray[3][0] = <21.494, -29.371, 4.476>  ;
#declare pointArray[3][1] = 1.000 ;
#declare pointArray[4][0] = <23.320, -31.941, 5.501>  ;
#declare pointArray[4][1] = 1.000 ;
#declare pointArray[5][0] = <24.834, -34.676, 6.571>  ;
#declare pointArray[5][1] = 1.000 ;
#declare pointArray[6][0] = <26.057, -37.530, 7.678>  ;
#declare pointArray[6][1] = 1.000 ;
#declare pointArray[7][0] = <27.011, -40.462, 8.818>  ;
#declare pointArray[7][1] = 1.000 ;
#declare pointArray[8][0] = <27.720, -43.442, 9.988>  ;
#declare pointArray[8][1] = 1.000 ;
#declare pointArray[9][0] = <28.205, -46.445, 11.190>  ;
#declare pointArray[9][1] = 1.000 ;
#declare pointArray[10][0] = <28.484, -49.451, 12.429>  ;
#declare pointArray[10][1] = 1.000 ;
#declare pointArray[11][0] = <28.573, -52.443, 13.711>  ;
#declare pointArray[11][1] = 1.000 ;
#declare pointArray[12][0] = <28.480, -55.402, 15.044>  ;
#declare pointArray[12][1] = 1.000 ;
#declare pointArray[13][0] = <28.204, -58.318, 16.448>  ;
#declare pointArray[13][1] = 1.000 ;
#declare pointArray[14][0] = <27.711, -61.230, 17.900>  ;
#declare pointArray[14][1] = 1.000 ;
#declare pointArray[15][0] = <26.962, -64.160, 19.279>  ;
#declare pointArray[15][1] = 1.000 ;
#declare pointArray[16][0] = <26.011, -67.069, 20.544>  ;
#declare pointArray[16][1] = 1.000 ;
#declare pointArray[17][0] = <24.909, -69.948, 21.714>  ;
#declare pointArray[17][1] = 1.000 ;
#declare pointArray[18][0] = <23.688, -72.799, 22.807>  ;
#declare pointArray[18][1] = 1.000 ;
#declare pointArray[19][0] = <22.371, -75.623, 23.837>  ;
#declare pointArray[19][1] = 1.000 ;
#declare pointArray[20][0] = <20.968, -78.421, 24.811>  ;
#declare pointArray[20][1] = 1.000 ;
#declare pointArray[21][0] = <19.490, -81.192, 25.736>  ;
#declare pointArray[21][1] = 1.000 ;
#declare pointArray[22][0] = <17.939, -83.938, 26.616>  ;
#declare pointArray[22][1] = 1.000 ;
#declare pointArray[23][0] = <16.314, -86.655, 27.452>  ;
#declare pointArray[23][1] = 1.000 ;
#declare pointArray[24][0] = <14.605, -89.338, 28.242>  ;
#declare pointArray[24][1] = 1.200 ;
#declare pointArray[25][0] = <12.788, -91.973, 28.979>  ;
#declare pointArray[25][1] = 1.442 ;
#declare pointArray[26][0] = <10.907, -94.549, 29.673>  ;
#declare pointArray[26][1] = 1.679 ;

#declare node = sphere {<0,0,0> 1} ;  
#declare centerPos = <0,0,0> ;

#declare bot_leg_right = 
object {
    intersection {
        union {
            #for (i,0,pointDataCount-1)
                object {node scale pointArray[i][1]*2.2 translate pointArray[i][0] + centerPos }
            #end 
            material {M_black_gloss translate centerPos}
        }         
        object { leg_right_sweep material {_m_metal} }   
        }
   translate -centerPos 
}




// -----------------------------------------------------------------------------------------
//                     B R A I N   B O T
//------------------------------------------------------------------------------------------
#declare brain_bot =
union { 
    
    object { body } 
    object { glass_helmet }
    object { eye }
    object { butt_bulb }
    object { butt }
    //---upper sockets 
    object { socket rotate <0,0,-90> translate <15,-4,0>  material {_m_metal} }
    object { socket rotate <0,0,90> translate <-15,-4,0>  material {_m_metal} }
    object { arm_socket rotate <0,0,0> translate <-23,-4,0>  material {_m_metal} }
    object { arm_socket rotate <0,0,0> translate <23,-4,0>  material {_m_metal} } 
    //---lower sockets
    object { socket rotate <0,0,-130> translate <11,-17,0>  material {_m_metal}}
    object { socket rotate <0,0,130> translate <-11,-17,0>  material {_m_metal} }    
    object { arm_socket rotate <0,0,0> translate <-17.7,-22.4,0>  material {_m_metal} }
    object { arm_socket rotate <0,0,0> translate <17.7,-22.4,0>  material {_m_metal} }  
    //---brains
    union {
        object { brain_left   translate <-.5,0,0> material {M_pearl_gloss}}
        object { brain_right  translate <.5,0,0>  material {M_pearl_gloss}}
    scale <.8,.9,.8>  
    translate <0,-4,0>
    }
    //---tentacles
    object { bot_arm_left translate <-2,5,2.9>}
    object { bot_arm_right translate <1,1,1> }
    object { bot_leg_left translate <-8,-.5,0>}
    object { bot_leg_right translate <4,0,-1.6> }
}  




